#version 430

in vec3 Normal;
in vec3 Position;

uniform vec3 cameraPos;
uniform samplerCube cube_texture;

const vec3 lightDirection = normalize(vec3(0.2, -1.0, 0.3));
const vec3 ambient = vec3(0.2f, 0.2f, 0.2f);

out vec4 Color;

void main() {
	vec3 modelColor = vec3(0.7f, 0.1f, 0.1f);
	vec3 brightness = max(dot(-lightDirection, normalize(Normal)), 0.0) + ambient;
	vec4 ReflectColor = vec4(modelColor * brightness, 1.0);

	vec3 I = normalize(Position - cameraPos);
	vec3 R = reflect(I, normalize(Normal));

	Color = texture(cube_texture, R);
	Color = mix(Color, ReflectColor, 0.3);
}